/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class HdPartition
extends MediaDevice {
    private static final String DOS_PARTITION = "/mnt/dos";

    HdPartition(MediaDeviceIdentifier id) throws MediaDeviceException {
        super(id);
        Trace.trace("XMDADEVT", "-> HdPartition.HdPartition(MediaDeviceIdentifier = " + id + ")");
        if (this.mediaDeviceProperties.getMountPoint().equals(DOS_PARTITION)) {
            this.mountWithUid = true;
        }
        Trace.trace("XMDADEVT", "<- HdPartition.HdPartition()");
    }

    boolean isMediaPresent() throws MediaDeviceLockException {
        Trace.trace("XMDADEVT", "-> HdPartition.isMediaPresent()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace("XMDADEVT", "<- HdPartition.isMediaPresent()");
        return true;
    }

    public String getLabel() throws MediaDeviceLockException, NoMediaPresentException {
        Trace.trace("XMDADEVT", "-> HdPartition.getLabel()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace("XMDADEVT", "<- HdPartition.getLabel()");
        return this.mediaDeviceProperties.getMountPoint();
    }

    String readLabelFile(String labelFile) throws IOException {
        Trace.trace("XMDADEVT", "<> HdPartition.readLabelFile(labelFile = " + labelFile + ")");
        return this.mediaDeviceProperties.getMountPoint();
    }

    public void lockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> HdPartition.lockDriveDoor()");
        throw new UnsupportedOperationException("The hard drive partition does not support drive door locking.");
    }

    public void unlockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> HdPartition.unlockDriveDoor()");
        throw new UnsupportedOperationException("The hard drive parition does not support drive door unlocking.");
    }

    public void format(String label, int fileSystemType) throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, IllegalArgumentException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> HdPartition.format(label = " + label + ", " + "fileSystemType = " + fileSystemType + ")");
        throw new UnsupportedOperationException("The hard drive partition does not support formatting.");
    }

    public void eject() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> HdPartition.eject()");
        throw new UnsupportedOperationException("The hard drive partition does not support media ejection.");
    }
}

